/*
 * Decompiled with CFR 0.152.
 */
package tv.mapper.mapperbase.world;

import java.util.List;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import tv.mapper.mapperbase.MapperBase;
import tv.mapper.mapperbase.config.BaseConfig;
import tv.mapper.mapperbase.world.CustomOre;
import tv.mapper.mapperbase.world.OreList;

public class BaseOreGenerator {
    private static boolean generate;

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void registerOreGen(BiomeLoadingEvent event) {
        for (CustomOre ore : OreList.ores) {
            if (!ore.canGenerate()) continue;
            String biome = event.getName().toString();
            if (ore.hasWhitelist()) {
                if (ore.getBiomeList().contains(biome)) {
                    generate = true;
                    if (((Boolean)BaseConfig.ClientConfig.ENABLE_GEN_LOGS.get()).booleanValue()) {
                        MapperBase.LOGGER.info(ore.name + " whitelisted for biome " + biome + " in the config.");
                    }
                } else {
                    generate = false;
                }
            } else if (ore.getBiomeList().contains(biome)) {
                generate = false;
                if (((Boolean)BaseConfig.ClientConfig.ENABLE_GEN_LOGS.get()).booleanValue()) {
                    MapperBase.LOGGER.info(ore.name + " blacklisted for biome " + biome + " in the config.");
                }
            } else {
                generate = true;
            }
            if (!generate) continue;
            event.getGeneration().m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, ore.getFeature());
        }
    }

    public static List<PlacementModifier> orePlacement(PlacementModifier amount, PlacementModifier modifier) {
        return List.of(amount, InSquarePlacement.m_191715_(), modifier, BiomeFilter.m_191561_());
    }

    public static List<PlacementModifier> commonOrePlacement(int amount, PlacementModifier modifier) {
        return BaseOreGenerator.orePlacement((PlacementModifier)CountPlacement.m_191628_((int)amount), modifier);
    }

    public static List<PlacementModifier> rareOrePlacement(int amount, PlacementModifier modifier) {
        return BaseOreGenerator.orePlacement((PlacementModifier)RarityFilter.m_191900_((int)amount), modifier);
    }
}

